#include <bits/stdc++.h>

using namespace std;

unsigned long long binomialCoeff(unsigned int n, unsigned int k)
{
    unsigned long long res = 1;

    if (k > n - k) k = n - k;

    for (int i = 0; i < k; ++i) {
        res *= (n - i);
        res /= (i + 1);
    }

    return res;
}

unsigned long long catalan(unsigned int n)
{
    unsigned long long c = binomialCoeff(2 * n, n);

    return c / (n + 1);
}

unsigned long long findWays(unsigned n)
{
    if (n & 1)
        return 0;

    return catalan(n / 2);
}

string kth_balanced(int n, int k) {
    vector<vector<int>> d(2*n+1, vector<int>(n+1, 0));
    d[0][0] = 1;
    for (int i = 1; i <= 2*n; i++) {
        d[i][0] = d[i-1][1];
        for (int j = 1; j < n; j++)
            d[i][j] = d[i-1][j-1] + d[i-1][j+1];
        d[i][n] = d[i-1][n-1];
    }

    string ans;
    int depth = 0;
    for (int i = 0; i < 2*n; i++) {
        if (depth + 1 <= n && d[2*n-i-1][depth+1] >= k) {
            ans += '(';
            depth++;
        } else {
            ans += ')';
            if (depth + 1 <= n)
                k -= d[2*n-i-1][depth+1];
            depth--;
        }
    }
    return ans;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0); cout.tie(0);
    int q, n, k, t;
    cin>>q;
    while(q--)
    {
        cin>>n>>k>>t;
        if(k>=n){
            t--;
            if((1<<n)<=t) cout<<"Ne postoji"<<endl;
            else{
            string binary = "";
            int mask = 1;
            for(int i = 0; i < n; i++)
            {
                if((mask&t) >= 1)
                    binary = ")"+binary;
                else
                    binary = "("+binary;
                mask<<=1;
            }
            cout<<binary<<endl;
        }   }

        else if(k==0 and (n%2)) cout<<"Ne postoji"<<endl;

        else if(((n%2)==0) and ((k==0) or (k==1))){
            if(t>findWays(n)) cout<<"Ne postoji"<<endl;
            else cout<<kth_balanced(n/2, t);
        }
        else cout<<"Ne postoji";
    }
    return 0;
}